// Generated by Haxe 4.0.0-rc.4+97f1e1a9d
// adapted to wledit 12jan2022 all credits basro
(function ($global) { "use strict";
function $extend(from, fields) {
	var proto = Object.create(from);
	for (var name in fields) proto[name] = fields[name];
	if( fields.toString !== Object.prototype.toString ) proto.toString = fields.toString;
	return proto;
}
var HxOverrides = function() { };
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) {
		return undefined;
	}
	return x;
};
var StringTools = function() { };
StringTools.endsWith = function(s,end) {
	var elen = end.length;
	var slen = s.length;
	if(slen >= elen) {
		return s.indexOf(end,slen - elen) == slen - elen;
	} else {
		return false;
	}
};
var bas_buffer_InBuffer = function(data,littleEndian) {
	if(littleEndian == null) {
		littleEndian = false;
	}
	this.data = data;
	this.littleEndian = littleEndian;
	this.pos = 0;
};
bas_buffer_InBuffer.decodeUTF8Char = function(src,offset) {
	var a = src.getUint8(offset);
	var b;
	var c;
	var d;
	var e;
	var f;
	var start = offset;
	var charCode;
	if((a & 128) == 0) {
		charCode = a;
		++offset;
	} else if((a & 224) == 192) {
		b = src.getUint8(offset + 1);
		charCode = (a & 31) << 6 | b & 63;
		offset += 2;
	} else if((a & 240) == 224) {
		b = src.getUint8(offset + 1);
		c = src.getUint8(offset + 2);
		charCode = (a & 15) << 12 | (b & 63) << 6 | c & 63;
		offset += 3;
	} else if((a & 248) == 240) {
		b = src.getUint8(offset + 1);
		c = src.getUint8(offset + 2);
		d = src.getUint8(offset + 3);
		charCode = (a & 7) << 18 | (b & 63) << 12 | (c & 63) << 6 | d & 63;
		offset += 4;
	} else if((a & 252) == 248) {
		b = src.getUint8(offset + 1);
		c = src.getUint8(offset + 2);
		d = src.getUint8(offset + 3);
		e = src.getUint8(offset + 4);
		charCode = (a & 3) << 24 | (b & 63) << 18 | (c & 63) << 12 | (d & 63) << 6 | e & 63;
		offset += 5;
	} else if((a & 254) == 252) {
		b = src.getUint8(offset + 1);
		c = src.getUint8(offset + 2);
		d = src.getUint8(offset + 3);
		e = src.getUint8(offset + 4);
		f = src.getUint8(offset + 5);
		charCode = (a & 1) << 30 | (b & 63) << 24 | (c & 63) << 18 | (d & 63) << 12 | (e & 63) << 6 | f & 63;
		offset += 6;
	} else {
		throw new js__$Boot_HaxeError("Cannot decode UTF8 character at offset " + offset + ": charCode (" + a + ") is invalid");
	}
	return { char : charCode, length : offset - start};
};
bas_buffer_InBuffer.prototype = {
	readInt8: function() {
		return this.data.getInt8(this.pos++);
	}
	,readUInt8: function() {
		return this.data.getUint8(this.pos++);
	}
	,readInt16: function() {
		var result = this.data.getInt16(this.pos,this.littleEndian);
		this.pos += 2;
		return result;
	}
	,readUInt16: function() {
		var result = this.data.getUint16(this.pos,this.littleEndian);
		this.pos += 2;
		return result;
	}
	,readInt32: function() {
		var result = this.data.getInt32(this.pos,this.littleEndian);
		this.pos += 4;
		return result;
	}
	,readUTF8StringBytes: function(length) {
		var offset = this.pos;
		var dec;
		var result = "";
		length = offset + length;
		while(offset < length) {
			dec = bas_buffer_InBuffer.decodeUTF8Char(this.data,offset);
			offset += dec.length;
			var code = dec.char;
			result += String.fromCodePoint(code);
		}
		if(offset != length) {
			throw new js__$Boot_HaxeError("Actual string length differs from the specified: " + (offset - length) + " bytes");
		}
		this.pos = offset;
		return result;
	}
};
var bas_buffer_OutBuffer = function(data,littleEndian) {
	if(littleEndian == null) {
		littleEndian = false;
	}
	this.data = data;
	this.littleEndian = littleEndian;
	this.pos = 0;
};
bas_buffer_OutBuffer.allocate = function(capacity,littleEndian) {
	if(littleEndian == null) {
		littleEndian = false;
	}
	if(capacity == null) {
		capacity = 16;
	}
	return new bas_buffer_OutBuffer(new DataView(new ArrayBuffer(capacity)),littleEndian);
};
bas_buffer_OutBuffer.encodeUTF8Char = function(charCode,dst,offset) {
	var start = offset;
	if(charCode < 0) {
		throw new js__$Boot_HaxeError("Cannot encode UTF8 character: charCode (" + charCode + ") is negative");
	}
	if(charCode < 128) {
		dst.setUint8(offset,charCode & 127);
		++offset;
	} else if(charCode < 2048) {
		dst.setUint8(offset,charCode >> 6 & 31 | 192);
		dst.setUint8(offset + 1,charCode & 63 | 128);
		offset += 2;
	} else if(charCode < 65536) {
		dst.setUint8(offset,charCode >> 12 & 15 | 224);
		dst.setUint8(offset + 1,charCode >> 6 & 63 | 128);
		dst.setUint8(offset + 2,charCode & 63 | 128);
		offset += 3;
	} else if(charCode < 2097152) {
		dst.setUint8(offset,charCode >> 18 & 7 | 240);
		dst.setUint8(offset + 1,charCode >> 12 & 63 | 128);
		dst.setUint8(offset + 2,charCode >> 6 & 63 | 128);
		dst.setUint8(offset + 3,charCode & 63 | 128);
		offset += 4;
	} else if(charCode < 67108864) {
		dst.setUint8(offset,charCode >> 24 & 3 | 248);
		dst.setUint8(offset + 1,charCode >> 18 & 63 | 128);
		dst.setUint8(offset + 2,charCode >> 12 & 63 | 128);
		dst.setUint8(offset + 3,charCode >> 6 & 63 | 128);
		dst.setUint8(offset + 4,charCode & 63 | 128);
		offset += 5;
	} else if(charCode < -2147483648) {
		dst.setUint8(offset,charCode >> 30 & 1 | 252);
		dst.setUint8(offset + 1,charCode >> 24 & 63 | 128);
		dst.setUint8(offset + 2,charCode >> 18 & 63 | 128);
		dst.setUint8(offset + 3,charCode >> 12 & 63 | 128);
		dst.setUint8(offset + 4,charCode >> 6 & 63 | 128);
		dst.setUint8(offset + 5,charCode & 63 | 128);
		offset += 6;
	} else {
		throw new js__$Boot_HaxeError("Cannot encode UTF8 character: charCode (" + charCode + ") is too large (>= 0x80000000)");
	}
	return offset - start;
};
bas_buffer_OutBuffer.calculateUTF8Char = function(charCode) {
	if(charCode < 0) {
		throw new js__$Boot_HaxeError("Cannot calculate length of UTF8 character: charCode (" + charCode + ") is negative");
	}
	if(charCode < 128) {
		return 1;
	} else if(charCode < 2048) {
		return 2;
	} else if(charCode < 65536) {
		return 3;
	} else if(charCode < 2097152) {
		return 4;
	} else if(charCode < 67108864) {
		return 5;
	} else if(charCode < -2147483648) {
		return 6;
	} else {
		throw new js__$Boot_HaxeError("Cannot calculate length of UTF8 character: charCode (" + charCode + ") is too large (>= 0x80000000)");
	}
};
bas_buffer_OutBuffer.calculateUTF8String = function(str) {
	var bytes = 0;
	var k = str.length;
	var _g = 0;
	while(_g < k) bytes += bas_buffer_OutBuffer.calculateUTF8Char(HxOverrides.cca(str,_g++));
	return bytes;
};
bas_buffer_OutBuffer.prototype = {
	toUint8Array: function() {
		return new Uint8Array(this.data.buffer,this.data.byteOffset,this.pos);
	}
	,ensureCapacity: function(capacity) {
		if(this.data.byteLength < capacity) {
			this.resize(this.data.byteLength * 2 >= capacity ? this.data.byteLength * 2 : capacity);
		}
	}
	,resize: function(capacity) {
		if(capacity < 1) {
			throw new js__$Boot_HaxeError("Can't resize buffer to a capacity lower than 1");
		}
		if(this.data.byteLength < capacity) {
			var srcView = new Uint8Array(this.data.buffer);
			var dst = new ArrayBuffer(capacity);
			new Uint8Array(dst).set(srcView);
			this.data = new DataView(dst);
		}
	}
	,writeUInt8: function(value) {
		var offset = this.pos++;
		this.ensureCapacity(this.pos);
		this.data.setUint8(offset,value);
	}
	,writeInt16: function(value) {
		var offset = this.pos;
		this.pos += 2;
		this.ensureCapacity(this.pos);
		this.data.setInt16(offset,value,this.littleEndian);
	}
	,writeUInt16: function(value) {
		var offset = this.pos;
		this.pos += 2;
		this.ensureCapacity(this.pos);
		this.data.setUint16(offset,value,this.littleEndian);
	}
	,writeUint8Array: function(src) {
		var offset = this.pos;
		this.pos += src.byteLength;
		this.ensureCapacity(this.pos);
		new Uint8Array(this.data.buffer,this.data.byteOffset,this.data.byteLength).set(src,offset);
	}
	,writeUTF8String: function(str) {
		var offset = this.pos;
		this.ensureCapacity(offset + bas_buffer_OutBuffer.calculateUTF8String(str));
		var j = str.length;
		var _g = 0;
		while(_g < j) offset += bas_buffer_OutBuffer.encodeUTF8Char(HxOverrides.cca(str,_g++),this.data,offset);
		this.pos = offset;
	}
};
var exe2wlmod = $global.exe2wlmod = function() { };

exe2wlmod.getJSON = function() {
	return JSON.stringify(webliero_format_WLMod.writeMod(webliero_format_LieroExe.read(exe2wlmod.lieroExe,null)));
};
exe2wlmod.getSprites = function() {
	var tcdata = webliero_format_LieroExe.read(exe2wlmod.lieroExe,exe2wlmod.lieroChr);
	var outBuffer = bas_buffer_OutBuffer.allocate(20000,true);
	webliero_format_WLSprites.write(outBuffer,tcdata.sprites,tcdata.palette);
	return outBuffer.toUint8Array().buffer;
};
var js__$Boot_HaxeError = function(val) {
	Error.call(this);
	this.val = val;
	if(Error.captureStackTrace) {
		Error.captureStackTrace(this,js__$Boot_HaxeError);
	}
};
js__$Boot_HaxeError.__super__ = Error;
js__$Boot_HaxeError.prototype = $extend(Error.prototype,{
});
var webliero_format_LieroExe = function() { };
webliero_format_LieroExe.read = function(exeData,chrData) {
	var exeData1 = new bas_buffer_InBuffer(new DataView(exeData),true);
	var tcdata = new webliero_tcdata_TCData();
	tcdata.textures = webliero_format_LieroExe.readTextures(exeData1);
	tcdata.materials = webliero_format_LieroExe.readMaterials(exeData1);
	tcdata.palette = webliero_format_LieroExe.readPalette(exeData1);
	tcdata.colorAnim = webliero_format_LieroExe.readColorAnim(exeData1);
	tcdata.constants = webliero_format_LieroExe.readConstants(exeData1);
	webliero_format_LieroExe.readWeaponsAndWObjects(tcdata,exeData1);
	tcdata.sObjects = webliero_format_LieroExe.readSObjects(exeData1);
	tcdata.nObjects = webliero_format_LieroExe.readNObjects(exeData1);
	tcdata.eObjects = webliero_format_LieroExe.makeEObjects();
	tcdata.crossHairSprite = 153;
	tcdata.textSpritesStartIdx = 240;
	tcdata.sprites = [];
	if(chrData != null) {
		var chrData1 = new bas_buffer_InBuffer(new DataView(chrData),false);
		var _g = 0;
		var _g1 = webliero_format_LieroExe.readLargeSprites(chrData1);
		while(_g < _g1.length) {
			var sprite = _g1[_g];
			++_g;
			sprite.offX = -7;
			sprite.offY = -7;
			tcdata.sprites.push(sprite);
		}
		var _g2 = 0;
		var _g3 = webliero_format_LieroExe.readSmallSprites(chrData1);
		while(_g2 < _g3.length) {
			var sprite1 = _g3[_g2];
			++_g2;
			sprite1.offX = -3;
			sprite1.offY = -3;
			tcdata.sprites.push(sprite1);
		}
		var _g4 = 0;
		var _g5 = webliero_format_LieroExe.readTextSprites(chrData1);
		while(_g4 < _g5.length) tcdata.sprites.push(_g5[_g4++]);
		var nrSprite = tcdata.sprites[84];
		nrSprite.offX = -1;
		nrSprite.offY = -1;
		var crossHair = tcdata.sprites[tcdata.crossHairSprite];
		crossHair.offX = -1;
		crossHair.offY = -2;
		var _g6 = 0;
		var _g7 = tcdata.sObjects;
		while(_g6 < _g7.length) {
			var sobj = _g7[_g6];
			++_g6;
			var _g61 = sobj.startFrame;
			var _g71 = sobj.startFrame + sobj.numFrames + 1;
			while(_g61 < _g71) {
				var sprite2 = tcdata.sprites[_g61++];
				sprite2.offX = -8;
				sprite2.offY = -8;
			}
		}
		var _g8 = 0;
		var _g9 = tcdata.sprites.length;
		while(_g8 < _g9) {
			var i = _g8++;
			tcdata.sprites[i] = tcdata.sprites[i].trim();
		}
	}
	tcdata.postProcess();
	return tcdata;
};
webliero_format_LieroExe.makeEObjects = function() {
	var result = [];
	var flag = new webliero_tcdata_EObjectType();
	flag.affectByExplosions = true;
	flag.bounce = Math.fround(0.5);
	flag.bounceFriction = Math.fround(0.9);
	flag.gravity = Math.fround(0.01);
	flag.multSpeed = Math.fround(1);
	flag.sprite = 214;
	flag.offsetX = 3;
	flag.offsetY = -3;
	result.push(flag);
	var id = 0;
	var _g = 0;
	while(_g < result.length) result[_g++].id = id++;
	return result;
};
webliero_format_LieroExe.readTextures = function(data) {
	var _g = [];
	var _g1 = 0;
	while(_g1 < 9) {
		++_g1;
		_g.push(new webliero_tcdata_Texture());
	}
	data.pos = 115208;
	var _g2 = 0;
	while(_g2 < 9) {
		var tmp = data.readUInt8();
		_g[_g2++].nDrawBack = tmp != 0;
	}
	data.pos = 115178;
	var _g3 = 0;
	while(_g3 < 9) _g[_g3++].mFrame = data.readUInt8();
	data.pos = 115188;
	var _g4 = 0;
	while(_g4 < 9) _g[_g4++].sFrame = data.readUInt8();
	data.pos = 115198;
	var _g5 = 0;
	while(_g5 < 9) _g[_g5++].rFrame = data.readUInt8();
	return _g;
};
webliero_format_LieroExe.readLargeSprites = function(data) {
	data.pos = 10;
	var _g = [];
	var _g1 = 0;
	while(_g1 < 110) {
		++_g1;
		_g.push(webliero_format_LieroExe.readSprite(data,16,16));
	}
	var rand = new webliero_state_Rand();
	var spr77 = _g[73];
	var spr74 = _g[74];
	var spr82 = _g[82];
	var spr83 = _g[83];
	var spr87 = _g[87];
	var spr88 = _g[88];
	var _g2 = 0;
	while(_g2 < 16) {
		var y = _g2++;
		var _g21 = 0;
		while(_g21 < 16) {
			var x = _g21++;
			rand.x = (rand.x * 1664525 >>> 0) + 1013904223 >>> 0;
			spr77.data[y * spr77.width + x] = (rand.x * 9.3132257461547852e-010 | 0) + 160;
			rand.x = (rand.x * 1664525 >>> 0) + 1013904223 >>> 0;
			spr74.data[y * spr74.width + x] = (rand.x * 9.3132257461547852e-010 | 0) + 160;
			rand.x = (rand.x * 1664525 >>> 0) + 1013904223 >>> 0;
			spr82.data[y * spr82.width + x] = (rand.x * 9.3132257461547852e-010 | 0) + 94;
			rand.x = (rand.x * 1664525 >>> 0) + 1013904223 >>> 0;
			spr83.data[y * spr83.width + x] = (rand.x * 9.3132257461547852e-010 | 0) + 94;
			rand.x = (rand.x * 1664525 >>> 0) + 1013904223 >>> 0;
			spr87.data[y * spr87.width + x] = (rand.x * 9.3132257461547852e-010 | 0) + 12;
			rand.x = (rand.x * 1664525 >>> 0) + 1013904223 >>> 0;
			spr88.data[y * spr88.width + x] = (rand.x * 9.3132257461547852e-010 | 0) + 12;
		}
	}
	return _g;
};
webliero_format_LieroExe.readSmallSprites = function(data) {
	data.pos += 4;
	var _g = [];
	var _g1 = 0;
	while(_g1 < 130) {
		++_g1;
		_g.push(webliero_format_LieroExe.readSprite(data,7,7));
	}
	return _g;
};
webliero_format_LieroExe.readTextSprites = function(data) {
	data.pos += 4;
	var _g = [];
	var _g1 = 0;
	while(_g1 < 26) {
		++_g1;
		_g.push(webliero_format_LieroExe.readSprite(data,4,4));
	}
	return _g;
};
webliero_format_LieroExe.readSprite = function(data,width,height) {
	var s = new webliero_tcdata_Sprite();
	s.width = width;
	s.height = height;
	s.data = new Uint8Array(width * height);
	var _g = 0;
	while(_g < width) {
		var x = _g++;
		var _g1 = 0;
		while(_g1 < height) s.data[_g1++ * width + x] = data.readUInt8();
	}
	return s;
};
webliero_format_LieroExe.readMaterials = function(data) {
	data.pos = 115424;
	var result = new Uint8Array(256);
	var _g = [];
	var _g1 = 0;
	while(_g1 < 32) {
		++_g1;
		_g.push(0);
	}
	var _g2 = 0;
	while(_g2 < 5) {
		var i = _g2++;
		var _g21 = 0;
		while(_g21 < 32) _g[_g21++] = data.readUInt8();
		var _g3 = 0;
		while(_g3 < 256) {
			var j = _g3++;
			result[j] |= (_g[j >> 3] >> (j & 7) & 1) << i;
		}
	}
	data.pos = 110248;
	var _g31 = 0;
	while(_g31 < 32) _g[_g31++] = data.readUInt8();
	var _g4 = 0;
	while(_g4 < 256) {
		var j1 = _g4++;
		result[j1] |= (_g[j1 >> 3] >> (j1 & 7) & 1) << 5;
	}
	return result;
};
webliero_format_LieroExe.readPalette = function(data) {
	data.pos = 132774;
	var palette = new Uint8Array(768);
	var _g = 0;
	while(_g < 768) palette[_g++] = (data.readUInt8() & 63) << 2;
	return palette;
};
webliero_format_LieroExe.readColorAnim = function(data) {
	data.pos = 110348;
	var colorAnim = [];
	var _g = 0;
	while(_g < 4) {
		++_g;
		colorAnim.push(data.readUInt8());
		colorAnim.push(data.readUInt8());
	}
	return colorAnim;
};
webliero_format_LieroExe.readHhackdesc = function(data,indicators) {
	var originalPos = data.pos;
	var active = true;
	var i = 0;
	while(i < indicators.length) {
		data.pos = indicators[i];
		if(data.readUInt8() != indicators[i + 1]) {
			active = false;
			break;
		}
		i += 2;
	}
	data.pos = originalPos;
	return active;
};
webliero_format_LieroExe.readConstants = function(data) {
	var CSint32desc = function(a,b) {
		data.pos = a;
		a = data.readUInt16();
		data.pos = b;
		b = data.readInt16();
		return a + (b << 16);
	};
	var CSint24desc = function(a1,b1) {
		data.pos = a1;
		a1 = data.readUInt16();
		data.pos = b1;
		b1 = data.readInt8();
		return a1 + (b1 << 16);
	};
	var CSint16desc = function(pos) {
		data.pos = pos;
		return data.readInt16();
	};
	var CSint8desc = function(pos1) {
		data.pos = pos1;
		return data.readInt8();
	};
	var CUint8desc = function(pos2) {
		data.pos = pos2;
		return data.readUInt8();
	};
	var Hhackdesc = function(indicators) {
		return webliero_format_LieroExe.readHhackdesc(data,indicators);
	};
	var c = new webliero_tcdata_Constants();
	var NRInitialLength = CSint32desc(13015,13021);
	var NRAttachLength = CSint32desc(42617,42623);
	c.MinBounceUp = Math.fround(CSint24desc(15229,15220) * 1.52587890625e-005);
	c.MinBounceDown = Math.fround(CSint24desc(15104,15095) * 1.52587890625e-005);
	c.MinBounceHoriz = Math.fround(CSint24desc(14854,14845) * 1.52587890625e-005);
	c.WormGravity = Math.fround(CSint24desc(15326,15319) * 1.52587890625e-005);
	c.WormAcc = Math.fround(CSint24desc(16408,16414) * 1.52587890625e-005);
	c.WormMaxVel = Math.fround(CSint24desc(16397,16388) * 1.52587890625e-005);
	c.JumpForce = Math.fround(CSint24desc(13095,13101) * 1.52587890625e-005);
	c.MaxAimVel = Math.fround(CSint24desc(12530,12521) * 1.52587890625e-005 * 3.1415926535897932 / 64);
	c.AimAcc = Math.fround(CSint24desc(12541,12547) * 1.52587890625e-005 * 3.1415926535897932 / 64);
	c.NinjaropeGravity = Math.fround(CSint24desc(43157,43163) * 1.52587890625e-005);
	var NRMinLength = CSint24desc(12806,12797);
	var NRMaxLength = CSint24desc(12841,12832);
	c.BonusGravity = Math.fround(CSint24desc(29379,29385) * 1.52587890625e-005);
	c.BObjGravity = Math.fround(CSint24desc(29770,29776) * 1.52587890625e-005);
	var WormFricDiv = CSint16desc(14791);
	c.WormFricMult = Math.fround(CSint16desc(14781) / WormFricDiv);
	c.AimFric = Math.fround(CSint16desc(12291) / CSint16desc(12301));
	c.NRThrowVel = Math.fround(1 << CSint16desc(12955));
	var NRForceMult = (1 << CSint16desc(43181)) / CSint16desc(43191);
	var NRForceLenShl = CSint16desc(43294);
	c.NRForce = Math.fround(NRForceMult / (1 << NRForceLenShl));
	c.BonusBounce = Math.fround(CSint16desc(29471) / CSint16desc(29481));
	c.BonusFlickerTime = CSint16desc(34744);
	c.SplinterLarpaVelDiv = CSint16desc(26493);
	c.SplinterCracklerVelDiv = CSint16desc(26576);
	var NRAdjustVel = CSint8desc(12752);
	c.FallDamageHoriz = CSint8desc(14862);
	c.FallDamageDown = CSint8desc(15112);
	c.FallDamageUp = CSint8desc(15237);
	var AimMaxLeft = CUint8desc(12390);
	c.AimMaxAngle = Math.fround((CUint8desc(12416) - 32) * 3.1415926535897932 / 64);
	c.AimMinAngle = Math.fround((AimMaxLeft - 32) * 3.1415926535897932 / 64);
	c.NRColourBegin = CUint8desc(69586);
	c.NRColourEnd = CUint8desc(69737);
	c.BonusExplodeRisk = CUint8desc(11698);
	c.BonusHealthVar = CUint8desc(11606);
	c.BonusMinHealth = CUint8desc(11613);
	c.FirstBloodColour = CUint8desc(9096);
	c.NumBloodColours = CUint8desc(9089);
	c.NRInitialLength = Math.fround(NRInitialLength / (1 << NRForceLenShl));
	c.NRAttachLength = Math.fround(NRAttachLength / (1 << NRForceLenShl));
	c.NRMinLength = Math.fround(NRMinLength / (1 << NRForceLenShl));
	c.NRMaxLength = Math.fround(NRMaxLength / (1 << NRForceLenShl));
	c.NRAdjustVel = Math.fround(NRAdjustVel / (1 << NRForceLenShl));
	c.HFallDamage = Hhackdesc([14858,38,14983,38,15108,38,15233,38]);
	c.HBonusReloadOnly = Hhackdesc([11697,235]);
	return c;
};
webliero_format_LieroExe.readWeaponsAndWObjects = function(dst,data) {
	data.pos = 112806;
	var _g = [];
	var _g1 = 0;
	while(_g1 < 40) {
		++_g1;
		_g.push(new webliero_tcdata_WeaponType());
	}
	var _g2 = [];
	var _g3 = 0;
	while(_g3 < 40) {
		++_g3;
		_g2.push(new webliero_tcdata_WObjectType());
	}
	var dataTypes = [8,8,8,8,-16,8,8,8,8,8,-16,-16,-16,8,8,-16,-16,-16,8,8,8,8,8,8,8,8,8,8,8,8,8,-16,-16,8,8,-16,8,8,8,8,8,8,8,8,8,8,8,8,8];
	var _g4 = [];
	var _g5 = 0;
	while(_g5 < 40) {
		++_g5;
		_g4.push([]);
	}
	var _g6 = 0;
	while(_g6 < dataTypes.length) {
		var dataType = dataTypes[_g6++];
		var _g61 = 0;
		while(_g61 < _g4.length) {
			var wdata = _g4[_g61];
			++_g61;
			if(dataType == -16) {
				wdata.push(data.readInt16());
			} else {
				wdata.push(data.readUInt8());
			}
		}
	}
	var _g7 = 0;
	while(_g7 < 40) {
		var i = _g7++;
		var weap = _g[i];
		var wobj = _g2[i];
		var dataValues = _g4[i];
		var detectDistance = dataValues[0];
		var affectByWorm = dataValues[1];
		var blowAway = dataValues[2];
		var gravity = dataValues[4];
		var laserSight = dataValues[6];
		var launchSound = dataValues[7];
		var exploSound = dataValues[9];
		var speed = dataValues[10];
		var addSpeed = dataValues[11];
		var distribution = dataValues[12];
		var parts = dataValues[13];
		var recoil = dataValues[14];
		var multSpeed = dataValues[15];
		var delay = dataValues[16];
		var loadingTime = dataValues[17];
		var ammo = dataValues[18];
		var createOnExp = dataValues[19];
		var dirtEffect = dataValues[20];
		var leaveShells = dataValues[21];
		var leaveShellDelay = dataValues[22];
		var playReloadSound = dataValues[23];
		var wormExplode = dataValues[24];
		var explGround = dataValues[25];
		var wormCollide = dataValues[26];
		var fireCone = dataValues[27];
		var collideWithObjects = dataValues[28];
		var affectByExplosions = dataValues[29];
		var bounce = dataValues[30];
		var timeToExplo = dataValues[31];
		var timeToExploV = dataValues[32];
		var hitDamage = dataValues[33];
		var bloodOnHit = dataValues[34];
		var startFrame = dataValues[35];
		var numFrames = dataValues[36];
		var loopAnim = dataValues[37];
		var shotType = dataValues[38];
		var colorBullets = dataValues[39];
		var splinterAmount = dataValues[40];
		var splinterColour = dataValues[41];
		var splinterType = dataValues[42];
		var splinterScatter = dataValues[43];
		var objTrailType = dataValues[44];
		var objTrailDelay = dataValues[45];
		var partTrailType = dataValues[46];
		var partTrailObj = dataValues[47];
		var partTrailDelay = dataValues[48];
		weap.bulletSpeed = Math.fround(speed / 100);
		if(affectByWorm != 0) {
			if(weap.bulletSpeed < 1) {
				weap.bulletSpeed = Math.fround(1);
			}
			weap.bulletSpeedInherit = Math.fround(1 / weap.bulletSpeed);
		} else {
			weap.bulletSpeedInherit = Math.fround(0);
		}
		weap.laserSight = laserSight != 0;
		weap.laserBeam = i == 28;
		weap.launchSound = launchSound - 1;
		weap.distribution = Math.fround(distribution * 1.52587890625e-005);
		weap.parts = parts;
		if(webliero_format_LieroExe.readHhackdesc(data,[14508,152,14572,152]) && recoil >= 128) {
			recoil -= 256;
		}
		weap.recoil = Math.fround(recoil / 100);
		weap.delay = delay;
		weap.loadingTime = loadingTime;
		weap.ammo = ammo;
		weap.leaveShells = leaveShells;
		weap.leaveShellDelay = leaveShellDelay;
		weap.playReloadSound = playReloadSound != 0;
		weap.fireCone = fireCone;
		wobj.detectDistance = detectDistance;
		wobj.blowAway = Math.fround(blowAway / 100);
		wobj.gravity = Math.fround(gravity * 1.52587890625e-005);
		wobj.exploSound = exploSound - 1;
		wobj.addSpeed = Math.fround(addSpeed);
		wobj.multSpeed = Math.fround(multSpeed / 100);
		wobj.createOnExp = createOnExp - 1;
		wobj.dirtEffect = dirtEffect - 1;
		wobj.wormExplode = wormExplode != 0;
		wobj.explGround = explGround != 0;
		wobj.wormCollide = wormCollide != 0;
		wobj.collideWithObjects = collideWithObjects != 0;
		wobj.affectByExplosions = affectByExplosions != 0;
		wobj.bounce = Math.fround(bounce / 100);
		wobj.bounceFriction = bounce == 100 ? Math.fround(1) : Math.fround(0.8);
		wobj.timeToExplo = timeToExplo;
		wobj.timeToExploV = timeToExploV;
		wobj.hitDamage = hitDamage;
		wobj.bloodOnHit = bloodOnHit;
		wobj.startFrame = startFrame;
		wobj.numFrames = numFrames;
		wobj.loopAnim = loopAnim != 0;
		wobj.shotType = shotType;
		wobj.repeat = 1;
		if(shotType == 4) {
			wobj.repeat = i == 28 ? 1000 : 8;
		}
		wobj.colorBullets = colorBullets;
		wobj.splinterAmount = splinterAmount;
		wobj.splinterColour = splinterColour;
		wobj.splinterType = splinterType - 1;
		wobj.splinterScatter = splinterScatter;
		wobj.objTrailType = objTrailType - 1;
		wobj.objTrailDelay = objTrailDelay;
		wobj.partTrailType = partTrailType;
		wobj.partTrailObj = partTrailObj - 1;
		wobj.partTrailDelay = partTrailDelay;
		wobj.speed = speed;
		wobj.distribution = Math.fround(distribution * 1.52587890625e-005);
	}
	data.pos = 112246;
	var _g8 = 0;
	while(_g8 < 40) {
		var i1 = _g8++;
		var pos = data.pos;
		var len = data.readUInt8();
		_g[i1].name = data.readUTF8StringBytes(len);
		_g[i1].id = i1;
		_g[i1].bulletType = i1;
		_g[i1].bulletTypeRef = _g2[i1];
		_g2[i1].id = i1;
		data.pos = pos + 14;
	}
	var resultCopy = _g.slice();
	resultCopy.sort(function(w1,w2) {
		if(w1.name == w2.name) {
			return 0;
		} else if(w1.name < w2.name) {
			return 1;
		} else {
			return -1;
		}
	});
	var _g9 = 0;
	var _g10 = resultCopy.length;
	while(_g9 < _g10) {
		var i2 = _g9++;
		var w = resultCopy[i2];
		var prevW = resultCopy[(i2 - 1 + 40) % 40];
		w.nextId = resultCopy[(i2 + 1) % 40].id;
		w.prevId = prevW.id;
	}
	var _g11 = 0;
	while(_g11 < _g2.length) {
		var obj = _g2[_g11];
		++_g11;
		if(obj.startFrame >= 0) {
			obj.startFrame += 110;
		}
	}
	dst.weapons = _g;
	dst.wObjects = _g2;
};
webliero_format_LieroExe.readSObjects = function(data) {
	data.pos = 115218;
	var _g = [];
	var _g1 = 0;
	while(_g1 < 14) {
		++_g1;
		_g.push(new webliero_tcdata_SObjectType());
	}
	var _g2 = 0;
	while(_g2 < 14) {
		var tmp = data.readUInt8();
		_g[_g2++].startSound = tmp - 1;
	}
	var _g3 = 0;
	while(_g3 < 14) _g[_g3++].numSounds = data.readUInt8();
	var _g4 = 0;
	while(_g4 < 14) _g[_g4++].animDelay = data.readUInt8();
	var _g5 = 0;
	while(_g5 < 14) _g[_g5++].startFrame = data.readUInt8();
	var _g6 = 0;
	while(_g6 < 14) _g[_g6++].numFrames = data.readUInt8();
	var _g7 = 0;
	while(_g7 < 14) _g[_g7++].detectRange = data.readUInt8();
	var _g8 = 0;
	while(_g8 < 14) _g[_g8++].damage = data.readUInt8();
	var _g9 = 0;
	while(_g9 < 14) {
		var tmp1 = Math.fround(data.readInt32() * 1.52587890625e-005);
		_g[_g9++].blowAway = tmp1;
	}
	data.pos = 115368;
	var _g10 = 0;
	while(_g10 < 14) {
		var tmp2 = data.readUInt8();
		_g[_g10++].shadow = tmp2 != 0;
	}
	var _g11 = 0;
	while(_g11 < 14) _g[_g11++].shake = data.readUInt8();
	var _g12 = 0;
	while(_g12 < 14) _g[_g12++].flash = data.readUInt8();
	var _g13 = 0;
	while(_g13 < 14) {
		var tmp3 = data.readUInt8();
		_g[_g13++].dirtEffect = tmp3 - 1;
	}
	var _g14 = 0;
	while(_g14 < 14) {
		var i = _g14++;
		_g[i].id = i;
	}
	return _g;
};
webliero_format_LieroExe.readNObjects = function(data) {
	data.pos = 111430;
	var _g = [];
	var _g1 = 0;
	while(_g1 < 24) {
		++_g1;
		_g.push(new webliero_tcdata_NObjectType());
	}
	var _g2 = 0;
	while(_g2 < 24) _g[_g2++].detectDistance = data.readUInt8();
	var _g3 = 0;
	while(_g3 < 24) {
		var tmp = Math.fround(data.readInt16() * 1.52587890625e-005);
		_g[_g3++].gravity = tmp;
	}
	var _g4 = 0;
	while(_g4 < 24) {
		var tmp1 = Math.fround(data.readInt16() / 100);
		_g[_g4++].speed = tmp1;
	}
	var _g5 = 0;
	while(_g5 < 24) {
		var tmp2 = Math.fround(data.readInt16() / 100);
		_g[_g5++].speedV = tmp2;
	}
	var _g6 = 0;
	while(_g6 < 24) {
		var tmp3 = Math.fround(data.readInt16() * 1.52587890625e-005);
		_g[_g6++].distribution = tmp3;
	}
	var _g7 = 0;
	while(_g7 < 24) {
		var tmp4 = Math.fround(data.readUInt8() / 100);
		_g[_g7++].blowAway = tmp4;
	}
	var _g8 = 0;
	while(_g8 < 24) {
		var tmp5 = Math.fround(data.readUInt8() / 100);
		_g[_g8++].bounce = tmp5;
	}
	var _g9 = 0;
	while(_g9 < 24) _g[_g9++].hitDamage = data.readUInt8();
	var _g10 = 0;
	while(_g10 < 24) {
		var tmp6 = data.readUInt8();
		_g[_g10++].wormExplode = tmp6 != 0;
	}
	var _g11 = 0;
	while(_g11 < 24) {
		var tmp7 = data.readUInt8();
		_g[_g11++].explGround = tmp7 != 0;
	}
	var _g12 = 0;
	while(_g12 < 24) {
		var tmp8 = data.readUInt8();
		_g[_g12++].wormDestroy = tmp8 != 0;
	}
	var _g13 = 0;
	while(_g13 < 24) _g[_g13++].bloodOnHit = data.readUInt8();
	var _g14 = 0;
	while(_g14 < 24) _g[_g14++].startFrame = data.readUInt8();
	var _g15 = 0;
	while(_g15 < 24) _g[_g15++].numFrames = data.readUInt8();
	var _g16 = 0;
	while(_g16 < 24) {
		var tmp9 = data.readUInt8();
		_g[_g16++].drawOnMap = tmp9 != 0;
	}
	var _g17 = 0;
	while(_g17 < 24) _g[_g17++].colorBullets = data.readUInt8();
	var _g18 = 0;
	while(_g18 < 24) {
		var tmp10 = data.readUInt8();
		_g[_g18++].createOnExp = tmp10 - 1;
	}
	var _g19 = 0;
	while(_g19 < 24) {
		var tmp11 = data.readUInt8();
		_g[_g19++].affectByExplosions = tmp11 != 0;
	}
	var _g20 = 0;
	while(_g20 < 24) {
		var tmp12 = data.readUInt8();
		_g[_g20++].dirtEffect = tmp12 - 1;
	}
	var _g21 = 0;
	while(_g21 < 24) _g[_g21++].splinterAmount = data.readUInt8();
	var _g22 = 0;
	while(_g22 < 24) _g[_g22++].splinterColour = data.readUInt8();
	var _g23 = 0;
	while(_g23 < 24) {
		var tmp13 = data.readUInt8();
		_g[_g23++].splinterType = tmp13 - 1;
	}
	var _g24 = 0;
	while(_g24 < 24) {
		var tmp14 = data.readUInt8();
		_g[_g24++].bloodTrail = tmp14 != 0;
	}
	var _g25 = 0;
	while(_g25 < 24) _g[_g25++].bloodTrailDelay = data.readUInt8();
	var _g26 = 0;
	while(_g26 < 24) {
		var tmp15 = data.readUInt8();
		_g[_g26++].leaveObj = tmp15 - 1;
	}
	var _g27 = 0;
	while(_g27 < 24) _g[_g27++].leaveObjDelay = data.readUInt8();
	var _g28 = 0;
	while(_g28 < 24) _g[_g28++].timeToExplo = data.readInt16();
	var _g29 = 0;
	while(_g29 < 24) _g[_g29++].timeToExploV = data.readInt16();
	var _g30 = 0;
	while(_g30 < 24) {
		var i = _g30++;
		_g[i].id = i;
	}
	var _g31 = 0;
	while(_g31 < _g.length) {
		var obj = _g[_g31];
		++_g31;
		if(obj.startFrame != 0) {
			obj.startFrame += 110;
		}
	}
	return _g;
};
var webliero_format_WLMod = function() { };
webliero_format_WLMod.writeMod = function(tcdata) {
	var tmp = webliero_format_WLMod.writeConstants(tcdata.constants);
	var _g = [];
	var _g1 = 0;
	var _g2 = tcdata.weapons;
	while(_g1 < _g2.length) _g.push(webliero_format_WLMod.writeWeaponType(_g2[_g1++]));
	var _g3 = [];
	var _g4 = 0;
	var _g5 = tcdata.wObjects;
	while(_g4 < _g5.length) _g3.push(webliero_format_WLMod.writeWObject(_g5[_g4++]));
	var _g6 = [];
	var _g7 = 0;
	var _g8 = tcdata.nObjects;
	while(_g7 < _g8.length) _g6.push(webliero_format_WLMod.writeNObject(_g8[_g7++]));
	var _g9 = [];
	var _g10 = 0;
	var _g11 = tcdata.sObjects;
	while(_g10 < _g11.length) _g9.push(webliero_format_WLMod.writeSObject(_g11[_g10++]));
	var _g12 = [];
	var _g13 = 0;
	var _g14 = tcdata.textures;
	while(_g13 < _g14.length) _g12.push(webliero_format_WLMod.writeTexture(_g14[_g13++]));
	return { "constants" : tmp, "weapons" : _g, "wObjects" : _g3, "nObjects" : _g6, "sObjects" : _g9, "textures" : _g12, "colorAnim" : tcdata.colorAnim, "textSpritesStartIdx" : tcdata.textSpritesStartIdx, "crossHairSprite" : tcdata.crossHairSprite};
};
webliero_format_WLMod.writeConstants = function(constants) {
	return { "nrInitialLength" : constants.NRInitialLength, "nrAttachLength" : constants.NRAttachLength, "minBounceUp" : constants.MinBounceUp, "minBounceDown" : constants.MinBounceDown, "minBounceHoriz" : constants.MinBounceHoriz, "wormGravity" : constants.WormGravity, "wormAcc" : constants.WormAcc, "wormMaxVel" : constants.WormMaxVel, "jumpForce" : constants.JumpForce, "maxAimVel" : constants.MaxAimVel, "aimAcc" : constants.AimAcc, "ninjaropeGravity" : constants.NinjaropeGravity, "nrMinLength" : constants.NRMinLength, "nrMaxLength" : constants.NRMaxLength, "bonusGravity" : constants.BonusGravity, "wormFricMult" : constants.WormFricMult, "aimFric" : constants.AimFric, "nrThrowVel" : constants.NRThrowVel, "nrForce" : constants.NRForce, "bonusBounce" : constants.BonusBounce, "bonusFlickerTime" : constants.BonusFlickerTime, "aimMaxAngle" : constants.AimMaxAngle, "aimMinAngle" : constants.AimMinAngle, "nrAdjustVel" : constants.NRAdjustVel, "nrColourBegin" : constants.NRColourBegin, "nrColourEnd" : constants.NRColourEnd, "bonusExplodeRisk" : constants.BonusExplodeRisk, "bonusHealthVar" : constants.BonusHealthVar, "bonusMinHealth" : constants.BonusMinHealth, "firstBloodColour" : constants.FirstBloodColour, "numBloodColours" : constants.NumBloodColours, "bObjGravity" : constants.BObjGravity, "splinterLarpaVelDiv" : constants.SplinterLarpaVelDiv, "splinterCracklerVelDiv" : constants.SplinterCracklerVelDiv, "fallDamageHoriz" : constants.FallDamageHoriz, "fallDamageDown" : constants.FallDamageDown, "fallDamageUp" : constants.FallDamageUp, "hFallDamage" : constants.HFallDamage, "hBonusReloadOnly" : constants.HBonusReloadOnly};
};
webliero_format_WLMod.writeSObject = function(obj) {
	return { "startSound" : obj.startSound, "numSounds" : obj.numSounds, "animDelay" : obj.animDelay, "startFrame" : obj.startFrame, "numFrames" : obj.numFrames, "detectRange" : obj.detectRange, "damage" : obj.damage, "blowAway" : obj.blowAway, "shadow" : obj.shadow, "shake" : obj.shake, "flash" : obj.flash, "dirtEffect" : obj.dirtEffect};
};
webliero_format_WLMod.writeNObject = function(obj) {
	return { "detectDistance" : obj.detectDistance, "gravity" : obj.gravity, "speed" : obj.speed, "speedV" : obj.speedV, "distribution" : obj.distribution, "blowAway" : obj.blowAway, "bounce" : obj.bounce, "hitDamage" : obj.hitDamage, "wormExplode" : obj.wormExplode, "explGround" : obj.explGround, "wormDestroy" : obj.wormDestroy, "bloodOnHit" : obj.bloodOnHit, "startFrame" : obj.startFrame, "numFrames" : obj.numFrames, "drawOnMap" : obj.drawOnMap, "colorBullets" : obj.colorBullets, "createOnExp" : obj.createOnExp, "affectByExplosions" : obj.affectByExplosions, "dirtEffect" : obj.dirtEffect, "splinterAmount" : obj.splinterAmount, "splinterColour" : obj.splinterColour, "splinterType" : obj.splinterType, "bloodTrail" : obj.bloodTrail, "bloodTrailDelay" : obj.bloodTrailDelay, "leaveObj" : obj.leaveObj, "leaveObjDelay" : obj.leaveObjDelay, "timeToExplo" : obj.timeToExplo, "timeToExploV" : obj.timeToExploV};
};
webliero_format_WLMod.writeWObject = function(obj) {
	return { "detectDistance" : obj.detectDistance, "blowAway" : obj.blowAway, "gravity" : obj.gravity, "exploSound" : obj.exploSound, "addSpeed" : obj.addSpeed, "distribution" : obj.distribution, "multSpeed" : obj.multSpeed, "createOnExp" : obj.createOnExp, "dirtEffect" : obj.dirtEffect, "wormExplode" : obj.wormExplode, "explGround" : obj.explGround, "wormCollide" : obj.wormCollide, "collideWithObjects" : obj.collideWithObjects, "affectByExplosions" : obj.affectByExplosions, "bounce" : obj.bounce, "bounceFriction" : obj.bounceFriction, "timeToExplo" : obj.timeToExplo, "timeToExploV" : obj.timeToExploV, "hitDamage" : obj.hitDamage, "bloodOnHit" : obj.bloodOnHit, "startFrame" : obj.startFrame, "numFrames" : obj.numFrames, "loopAnim" : obj.loopAnim, "shotType" : obj.shotType, "repeat" : obj.repeat, "colorBullets" : obj.colorBullets, "splinterAmount" : obj.splinterAmount, "splinterColour" : obj.splinterColour, "splinterType" : obj.splinterType, "splinterScatter" : obj.splinterScatter, "objTrailType" : obj.objTrailType, "objTrailDelay" : obj.objTrailDelay, "partTrailType" : obj.partTrailType, "partTrailObj" : obj.partTrailObj, "partTrailDelay" : obj.partTrailDelay, "speed" : obj.speed};
};
webliero_format_WLMod.writeWeaponType = function(obj) {
	return { "parts" : obj.parts, "bulletType" : obj.bulletType, "bulletSpeed" : obj.bulletSpeed, "bulletSpeedInherit" : obj.bulletSpeedInherit, "distribution" : obj.distribution, "recoil" : obj.recoil, "ammo" : obj.ammo, "delay" : obj.delay, "loadingTime" : obj.loadingTime, "leaveShells" : obj.leaveShells, "leaveShellDelay" : obj.leaveShellDelay, "fireCone" : obj.fireCone, "laserSight" : obj.laserSight, "laserBeam" : obj.laserBeam, "launchSound" : obj.launchSound, "playReloadSound" : obj.playReloadSound, "name" : obj.name};
};
webliero_format_WLMod.writeTexture = function(obj) {
	return { "nDrawBack" : obj.nDrawBack, "mFrame" : obj.mFrame, "sFrame" : obj.sFrame, "rFrame" : obj.rFrame};
};
var webliero_format_WLSprites = function() { };
webliero_format_WLSprites.write = function(data,sprites,pal) {
	data.writeUTF8String("WLSPRT");
	data.writeUInt16(0);
	data.writeUInt8(pal != null ? 1 : 0);
	if(pal != null) {
		var _g = 0;
		while(_g < 768) data.writeUInt8(pal[_g++]);
	}
	data.writeUInt16(sprites.length);
	var _g1 = 0;
	while(_g1 < sprites.length) {
		var sprite = sprites[_g1];
		++_g1;
		data.writeUInt16(sprite.width);
		data.writeUInt16(sprite.height);
		data.writeInt16(sprite.offX);
		data.writeInt16(sprite.offY);
		data.writeUint8Array(sprite.data);
	}
};
var webliero_state_Rand = function(newSeed) {
	if(newSeed == null) {
		newSeed = 4919;
	}
	this.x = newSeed >>> 0;
};
var webliero_tcdata_Constants = function() {
};
var webliero_tcdata_EObjectType = function() {
};
var webliero_tcdata_NObjectType = function() {
};
var webliero_tcdata_SObjectType = function() {
};
var webliero_tcdata_Sprite = function() {
	this.offY = 0;
	this.offX = 0;
};
webliero_tcdata_Sprite.make = function(width,height) {
	var sprite = new webliero_tcdata_Sprite();
	sprite.width = width;
	sprite.height = height;
	sprite.data = new Uint8Array(width * height);
	return sprite;
};
webliero_tcdata_Sprite.prototype = {
	trim: function() {
		var minX = this.width - 1;
		var maxX = 0;
		var minY = this.height - 1;
		var maxY = 0;
		var _g = 0;
		var _g1 = this.height;
		while(_g < _g1) {
			var y = _g++;
			var _g2 = 0;
			var _g11 = this.width;
			while(_g2 < _g11) {
				var x = _g2++;
				if(this.data[y * this.width + x] != 0) {
					if(minX > x) {
						minX = x;
					}
					if(maxX < x) {
						maxX = x;
					}
					if(minY > y) {
						minY = y;
					}
					if(maxY < y) {
						maxY = y;
					}
				}
			}
		}
		++maxX;
		++maxY;
		var twidth = maxX - minX;
		var theight = maxY - minY;
		if(twidth <= 0) {
			twidth = 1;
		}
		if(theight <= 0) {
			theight = 1;
		}
		var sprite = webliero_tcdata_Sprite.make(twidth,theight);
		sprite.offX = minX + this.offX;
		sprite.offY = minY + this.offY;
		var _g21 = minY;
		var _g3 = maxY;
		while(_g21 < _g3) {
			var y1 = _g21++;
			var _g22 = minX;
			var _g31 = maxX;
			while(_g22 < _g31) {
				var x1 = _g22++;
				sprite.data[(y1 - minY) * sprite.width + (x1 - minX)] = this.data[y1 * this.width + x1];
			}
		}
		return sprite;
	}
};
var webliero_tcdata_TCData = function() {
	this.materials = new Uint8Array(256);
	this.palette = new Uint8Array(768);
	this.sprites = [];
	this.colorAnim = [];
	this.textures = [];
	this.eObjects = [];
	this.sObjects = [];
	this.nObjects = [];
	this.wObjects = [];
	this.weapons = [];
	this.constants = new webliero_tcdata_Constants();
};
webliero_tcdata_TCData.prototype = {
	postProcess: function() {
		var setIds = function(list) {
			var _g = 0;
			var _g1 = list.length;
			while(_g < _g1) {
				var i = _g++;
				list[i].id = i;
			}
		};
		setIds(this.weapons);
		setIds(this.wObjects);
		setIds(this.nObjects);
		setIds(this.sObjects);
		var _g2 = 0;
		var _g11 = this.weapons;
		while(_g2 < _g11.length) {
			var w = _g11[_g2];
			++_g2;
			w.bulletTypeRef = this.wObjects[w.bulletType];
		}
	}
};
var webliero_tcdata_Texture = function() {
};
var webliero_tcdata_WObjectType = function() {
};
var webliero_tcdata_WeaponType = function() {
};
if( String.fromCodePoint == null ) String.fromCodePoint = function(c) { return c < 0x10000 ? String.fromCharCode(c) : String.fromCharCode((c>>10)+0xD7C0)+String.fromCharCode((c&0x3FF)+0xDC00); }
Object.defineProperty(js__$Boot_HaxeError.prototype,"message",{ get : function() {
	return String(this.val);
}});
//exe2wlmod.main();
})(window);
